/*!\file: surfaceslope_core.cpp
 * \brief: core of the slope solution 
 */ 

#include "./solutions.h"
#include "../toolkits/toolkits.h"
#include "../classes/objects/objects.h"
#include "../shared/io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../solvers/solvers.h"
#include "../modules/modules.h"

void surfaceslope_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	if(VerboseSolution()) _pprintLine_("computing slope...");

	/*Call on core computations: */
	femmodel->SetCurrentConfiguration(SurfaceSlopeAnalysisEnum,SurfaceSlopeXAnalysisEnum);
	solver_linear(femmodel);
	femmodel->SetCurrentConfiguration(SurfaceSlopeAnalysisEnum,SurfaceSlopeYAnalysisEnum);
	solver_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _pprintLine_("saving results:");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,SurfaceSlopeXEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,SurfaceSlopeYEnum);
	}

}
