/*! \file CreateLoadsThermal.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../shared/io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsThermal(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int      dim;
	int      numberofvertices;
	Pengrid *pengrid          = NULL;

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*Fetch parameters: */
	iomodel->Constant(&dim,MeshDimensionEnum);
	iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads();

	/*return if 2d mesh*/
	if (dim==2) _error_("2d meshes not supported yet");

	//create penalties for nodes: no node can have a temperature over the melting point
	iomodel->FetchData(2,ThermalSpctemperatureEnum,MeshElementsEnum);
	CreateSingleNodeToElementConnectivity(iomodel);

	for(int i=0;i<numberofvertices;i++){

		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){
			if (xIsNan<IssmDouble>(iomodel->Data(ThermalSpctemperatureEnum)[i])){ //No penalty applied on spc nodes!
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,ThermalAnalysisEnum));
			}
		}
	}
	iomodel->DeleteData(2,ThermalSpctemperatureEnum,MeshElementsEnum);

	/*Assign output pointer: */
	*ploads=loads;
}
