function md = model(varargin)
%MODEL - constructor for a model
%
%   Usage:
%      md = model(varargin)

switch nargin

case 0
	% if no input arguments, create a default object

	%Model general information
	md.notes='';
	md.name='';
	md.counter=0; %1 mesh, 2 geography, 3 parameterize
	md.domainoutline=NaN;
	md.riftoutline=NaN;
	md.iceshelfoutline=NaN;
	md.icesheetoutline=NaN;
	md.wateroutline=NaN;
	md.parameterfile=NaN;
	
	%Mesh
	md.type='';
	md.numberofelements=0;
	md.numberofgrids=0;
	md.elements=NaN;
	md.elements_type=NaN;
	md.x=NaN;
	md.y=NaN;
	md.z=NaN;
	md.bed_slopex=NaN;
	md.bed_slopey=NaN;
	md.surface_slopex=NaN;
	md.surface_slopey=NaN;
	md.nodeconnectivity=NaN;
	md.elementconnectivity=NaN;

	%Initial 2d mesh 
	md.numberofelements2d=0;
	md.numberofgrids2d=0;
	md.elements2d=NaN;
	md.elements_type2d=NaN;
	md.x2d=NaN;
	md.y2d=NaN;
	md.z2d=NaN;
		
	%Elements type
	md.ishutter=0;
	md.ismacayealpattyn=0;
	md.isstokes=0;

	%Elements
	md.elementonhutter=NaN;
	md.elementonmacayeal=NaN;
	md.elementonpattyn=NaN;
	md.elementonstokes=NaN;

	%Nodes
	md.gridonhutter=NaN;
	md.gridonmacayeal=NaN;
	md.gridonpattyn=NaN;
	md.gridonstokes=NaN;
	md.borderstokes=NaN;

	%Stokes mesh
	md.stokesreconditioning=0;
	
	%Penalties
	md.penalties=NaN;
	md.penalty_offset=0;
	md.penalty_melting=0;
	md.penalty_lock=0;
	md.segments=NaN;
	md.segmentmarkers=NaN;
	md.rifts=NaN;
	md.numrifts=0;

	%Projections
	md.uppergrids=NaN;
	md.lowergrids=NaN;
	md.deadgrids=NaN;
	
	%Extrusion
	md.numlayers=0;
	md.extrusionexponent=0;
	md.elementonbed=NaN;
	md.elementonsurface=NaN;
	md.gridonbed=NaN;
	md.gridonsurface=NaN;
	md.minh=0;
	md.firn_layer=NaN;
	md.dof=NaN;

	%Extraction
	md.extractedgrids=NaN;
	md.extractedelements=NaN;
	
	%Materials parameters
	md.rho_ice=0;
	md.rho_water=0;
	md.rho_firn=0;
	md.heatcapacity=0;
	md.latentheat=0;
	md.thermalconductivity=0;
	md.meltingpoint=0;
	md.beta=0;
	md.mixed_layer_capacity=0;
	md.thermal_exchange_velocity=0;
	
	%Physical parameters
	md.g=0;
	md.yts=0;
	md.drag=NaN;
	md.drag_type=0;
	md.p=NaN;
	md.q=NaN;
	md.B=NaN;
	md.n=NaN;

	%Geometrical parameters
	md.elementoniceshelf=NaN;
	md.elementonicesheet=NaN;
	md.elementonwater=NaN;
	md.gridoniceshelf=NaN;
	md.gridonicesheet=NaN;
	md.gridonwater=NaN;
	md.surface=NaN;
	md.thickness=NaN;
	md.bed=NaN;

	%Boundary conditions
	md.gridonboundary=NaN;
	%Diagnostic
	md.segmentonneumann_diag=NaN;
	md.neumannvalues_diag=NaN;
	md.gridondirichlet_diag=NaN;
	md.dirichletvalues_diag=NaN;
	
	%Diagnostic stokes
	md.segmentonneumann_diag_stokes=NaN;

	%Thermal
	md.min_thermal_constraints=0;
	md.gridondirichlet_thermal=NaN;
	md.dirichletvalues_thermal=NaN;

	%Transient
	md.segmentonneumann_prog=NaN;
	md.neumannvalues_prog=NaN;
	md.segmentonneumann_prog2=NaN;
	md.neumannvalues_prog2=NaN;
	md.gridondirichlet_prog=NaN;
	md.dirichletvalues_prog=NaN;

	%Observations
	md.vx_obs=NaN;
	md.vy_obs=NaN;
	md.vel_obs=NaN;
	md.vx_obs_raw=NaN;
	md.vy_obs_raw=NaN;
	md.vel_obs_raw=NaN;
	md.accumulation=NaN;
	md.geothermalflux=NaN;
	md.observed_temperature=NaN;

	%Statics parameters
	md.eps_rel=0;
	md.eps_abs=0;
	md.sparsity=0;
	md.connectivity=0;
	md.lowmem=0;
	md.viscosity_overshoot=0;
	
	%Transient parameters
	md.dt=0;
	md.ndt=0;
	md.artificial_diffusivity=0;
	md.timestepping=0;
	md.deltaH=0;
	md.DeltaH=0;
	md.deltaT=0;
	md.DeltaT=0;
	md.timeacc=0;
	md.timedec=0;

	%Control
	md.control_type='';
	md.nsteps=0;
	md.maxiter=[];
	md.tolx=0;
	md.optscal=[];
	md.mincontrolconstraint=0;
	md.maxcontrolconstraint=0;
	md.fit=[];
	md.epsvel=0;
	md.meanvel=0;

	%Output parameters
	md.parameteroutput={};
	md.viscousheating=NaN;
	md.pressure_elem=NaN;
	md.stress=NaN;
	md.stress_surface=NaN;
	md.stress_bed=NaN;
	md.deviatoricstress=NaN;
	md.strainrate=NaN;
	md.plot=0;

	%debugging
	md.debug=0;
	md.element_debug=0;
	md.element_debugid=NaN;

	%Results fields
	md.results=NaN;
	md.vx=NaN;
	md.vy=NaN;
	md.vz=NaN;
	md.vel=NaN;
	md.temperature=NaN; %temperature solution vector
	md.melting=NaN;
	md.pressure=NaN;

	%Parallelisation parameters
	md.cluster='';
	md.np=0;
	md.time=0;
	md.queue='';
	md.exclusive=0;
	md.scheduler_configuration='';
	md.outlog='';
	md.errlog='';
	md.alloc_cleanup=1;
	md.waitonlock=0;

	%mesh2grid
	md.mesh2grid_parameters={};
	md.mesh2grid_interpolation={};
	md.mesh2grid_filter={};
	md.mesh2grid_cornereast=0;
	md.mesh2grid_cornernorth=0;
	md.mesh2grid_xposting=0;
	md.mesh2grid_yposting=0;
	md.mesh2grid_nlines=0;
	md.mesh2grid_ncolumns=0;
	md.mesh2grid_windowsize=0;
	md.mesh2grid_results=NaN;
	md.dummy=NaN;

	%mesh 
	md.mesh_domainoutline='';
	md.mesh_riftoutline='';
	md.mesh_resolution=NaN;

	%Cielo solver string
	md.solverstring='';
	md.analysis_type='';
	md.sub_analysis_type='';

	%management of large models
	md.repository='';

	%radar power images
	md.sarpwr=NaN;
	md.sarxm=NaN;
	md.sarym=NaN;

	%qmu
	md.variables=struct();
	md.responses=struct();
	md.qmu_method=struct();
	md.qmu_params=struct();
	md.dakotaresults=struct();
	md.dakotain='';
	md.dakotaout='';
	md.dakotadat='';
	md.qmu_analysis=0;
	md.part=[];
	md.npart=0;
	md.numberofvariables=0;
	md.numberofresponses=0;
	md.variabledescriptors=NaN;
	md.responsedescriptors=NaN;

	%Ice solver string
	md.solver_type='';

	%output
	md=class(md,'model');

	%set default parameters
	md=setdefaultparameters(md);

case 1
	%If single argument of class model, we have a copy constructor. 
	if (isa(varargin{1},'model'))
		md = varargin{1};
	elseif (isa(varargin{1},'char'))
		%user gave us the name of the repository, this model is going to be large! 
		md=model;
		md.repository=varargin{1};
		md=activaterepository(md);
	else
		error('model constructor error message: copy constructor called on a non ''model'' class object');
	end 
otherwise
	error('model constructor error message: 0 of 1 argument only in input.');
end
