/*!\file: thermal_core.cpp
 * \brief: core of the thermal solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../classes/objects/objects.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void thermal_core(FemModel* femmodel){

	/*intermediary*/
	bool   save_results;
	bool   dakota_analysis  = false;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&dakota_analysis,QmuIsdakotaEnum);

	if(dakota_analysis){
		femmodel->SetCurrentConfiguration(ThermalAnalysisEnum);
		ResetConstraintsx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
	}

	if(VerboseSolution()) _pprintLine_("   computing temperatures");
	femmodel->SetCurrentConfiguration(ThermalAnalysisEnum);
	solver_thermal_nonlinear(femmodel);

	if(VerboseSolution()) _pprintLine_("   computing melting");
	femmodel->SetCurrentConfiguration(MeltingAnalysisEnum);
	solver_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _pprintLine_("   saving results");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,TemperatureEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BasalforcingsMeltingRateEnum);
	}
}
