/*!\file: enthalpy_core.cpp
 * \brief: core of the enthalpy solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../classes/objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../io/io.h"
#include "../solvers/solvers.h"

void enthalpy_core(FemModel* femmodel){

	/*intermediary*/
	bool   save_results;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	if(VerboseSolution()) _pprintLine_("   computing enthalpy");
	femmodel->SetCurrentConfiguration(EnthalpyAnalysisEnum);
	solver_nonlinear(femmodel,true);

	/*transfer enthalpy to enthalpy picard for the next step: */
	InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,EnthalpyEnum,EnthalpyPicardEnum);

	if(save_results){
		if(VerboseSolution()) _pprintLine_("   saving results");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,TemperatureEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,EnthalpyEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,WaterfractionEnum);
	}
}
