/*!\file: SortDataSets.cpp
 * \brief sort datasets created in CreateDataSets
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../classes/objects/objects.h"
#include "../../shared/shared.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "./ModelProcessorx.h"

void SortDataSets(Elements** pelements,Nodes** pnodes,Vertices** pvertices, Loads** ploads, Materials** pmaterials, Constraints** pconstraints, Parameters** pparameters){

	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Constraints* constraints=NULL;
	Parameters* parameters=NULL;

	/*Recover pointers: */
	elements=*pelements;
	nodes=*pnodes;
	vertices=*pvertices;
	loads=*ploads;
	materials=*pmaterials;
	constraints=*pconstraints;
	parameters=*pparameters;

	/*All our datasets are already ordered by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */

	if(elements)elements->Presort();
	if(nodes)nodes->Presort();
	if(vertices)vertices->Presort();
	if(loads)loads->Presort();
	if(materials)materials->Presort();
	if(constraints)constraints->Presort();
	if(parameters)parameters->Presort();

}
