/*!\file: CreateParametersHydrologyDCInefficient.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersHydrologyDCInefficient(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){

	Parameters *parameters = NULL;
	int         hydrology_model;
	int         sedimentlimit_flag;
	bool        isefficientlayer;
	IssmDouble  sedimentlimit;
	IssmDouble  penalty_factor;

	/*Get parameters: */
	parameters=*pparameters;

	/*retrieve some parameters: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);

	/*Now, do we really want DC?*/
	if(hydrology_model!=HydrologydcEnum){
		*pparameters=parameters;
		return;
	}

	iomodel->FetchData(&isefficientlayer,HydrologydcIsefficientlayerEnum);
	iomodel->FetchData(&sedimentlimit_flag,HydrologydcSedimentlimitFlagEnum);
	iomodel->FetchData(&penalty_factor,HydrologydcPenaltyFactorEnum);

	if(sedimentlimit_flag==1){
		iomodel->FetchData(&sedimentlimit,HydrologydcSedimentlimitEnum);
		parameters->AddObject(new DoubleParam(HydrologydcSedimentlimitEnum,sedimentlimit));
	}

	parameters->AddObject(new DoubleParam(HydrologydcPenaltyFactorEnum,penalty_factor));
	parameters->AddObject(new IntParam(HydrologyModelEnum,hydrology_model));
	parameters->AddObject(new BoolParam(HydrologydcIsefficientlayerEnum,isefficientlayer));
	parameters->AddObject(new IntParam(HydrologydcSedimentlimitFlagEnum,sedimentlimit_flag));

	/*Assign output pointer: */
	*pparameters=parameters;
}
