/*!\file InputUpdateFromMatrixDakotax
 * \brief: update datasets using  parameter inputs
 */

#include "./InputUpdateFromMatrixDakotax.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../InputUpdateFromVectorDakotax/InputUpdateFromVectorDakotax.h"

void InputUpdateFromMatrixDakotax( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,double* matrix,int nrows,int ncols, int name, int type){

	int i;
	int numberofvertices;

	numberofvertices=vertices->NumberOfVertices();

	if((ncols==1) && (nrows==numberofvertices)) InputUpdateFromVectorDakotax( elements,nodes, vertices,loads, materials,  parameters,matrix, name,type);
	else{

		/*Update elements, nodes, loads and materials from inputs: */
		for(i=0;i<elements->Size();i++){
			Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
			element->InputUpdateFromMatrixDakota(matrix,nrows,ncols,name,type);
		}
		for(i=0;i<nodes->Size();i++){
			Node* node=(Node*)nodes->GetObjectByOffset(i);
			node->InputUpdateFromMatrixDakota(matrix,nrows,ncols,name,type);
		}
		for(i=0;i<loads->Size();i++){
			Load* load=(Load*)loads->GetObjectByOffset(i);
			load->InputUpdateFromMatrixDakota(matrix,nrows,ncols,name,type);
		}
		for(i=0;i<materials->Size();i++){
			Material* material=(Material*)materials->GetObjectByOffset(i);
			material->InputUpdateFromMatrixDakota(matrix,nrows,ncols,name,type);
		}
	}

}
