/*!\file BoolParam.c
 * \brief: implementation of the BoolParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../shared/shared.h"
#include "../../../Container/Container.h"
/*}}}*/

/*BoolParam constructors and destructor*/
/*FUNCTION BoolParam::BoolParam(){{{*/
BoolParam::BoolParam(){
	return;
}
/*}}}*/
/*FUNCTION BoolParam::BoolParam(int enum_type,bool value){{{*/
BoolParam::BoolParam(int in_enum_type,bool in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION BoolParam::~BoolParam(){{{*/
BoolParam::~BoolParam(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION BoolParam::Echo {{{*/
void BoolParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BoolParam::DeepEcho{{{*/
void BoolParam::DeepEcho(void){

	_printLine_("BoolParam:");
	_printLine_("   enum:  " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   value: " <<(this->value?"true":"false"));
}
/*}}}*/
/*FUNCTION BoolParam::Id{{{*/
int    BoolParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BoolParam::ObjectEnum{{{*/
int BoolParam::ObjectEnum(void){

	return BoolParamEnum;

}
/*}}}*/
/*FUNCTION BoolParam::copy{{{*/
Object* BoolParam::copy() {

	return new BoolParam(this->enum_type,this->value);

}
/*}}}*/

/*BoolParam virtual functions definitions: */
/*FUNCTION BoolParam::GetParameterName{{{*/
void BoolParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION BoolParam::UnitConversion{{{*/
void  BoolParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
