/*!\file KML_Style.cpp
 * \brief: implementation of the kml_style object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../../shared/shared.h"
#include "../../../io/io.h"
#include "../../../Container/Container.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Style::KML_Style(){{{*/
KML_Style::KML_Style(){

	icon      =NULL;
	label     =NULL;
	line      =NULL;
	poly      =NULL;
	balloon   =NULL;
	list      =NULL;

}
/*}}}*/
/*FUNCTION KML_Style::~KML_Style(){{{*/
KML_Style::~KML_Style(){

	if (list) {
//		delete list;
		list      =NULL;
	}
	if (balloon) {
//		delete balloon;
		balloon   =NULL;
	}
	if (poly) {
		delete poly;
		poly      =NULL;
	}
	if (line) {
		delete line;
		line      =NULL;
	}
	if (label) {
//		delete label;
		label     =NULL;
	}
	if (icon) {
//		delete icon;
		icon      =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Style::Echo {{{*/
void  KML_Style::Echo(){

	bool  flag=true;

	if(flag) _pprintLine_("KML_Style:");
	KML_StyleSelector::Echo();

	if(flag) _pprintLine_("          icon: " << icon);
	if(flag) _pprintLine_("         label: " << label);
	if(flag) _pprintLine_("          line: " << line);
	if(flag) _pprintLine_("          poly: " << poly);
	if(flag) _pprintLine_("       balloon: " << balloon);
	if(flag) _pprintLine_("          list: " << list);

	return;
}
/*}}}*/
/*FUNCTION KML_Style::DeepEcho {{{*/
void  KML_Style::DeepEcho(){

	char  indent[81]="";

	KML_Style::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION KML_Style::DeepEcho {{{*/
void  KML_Style::DeepEcho(const char* indent){

	char  indent2[81];
	bool  flag=true;

	if(flag) _pprintLine_(indent << "KML_Style:");
	KML_StyleSelector::DeepEcho(indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));
	strcat(indent2,"  ");

//	if (icon)
//		icon->DeepEcho(indent2);
//	else
		if(flag) _pprintLine_(indent << "          icon: " << icon);
//	if (label)
//		label->DeepEcho(indent2);
//	else
		if(flag) _pprintLine_(indent << "         label: " << label);
	if (line)
		line->DeepEcho(indent2);
	else
		if(flag) _pprintLine_(indent << "          line: " << line);
	if (poly)
		poly->DeepEcho(indent2);
	else
		if(flag) _pprintLine_(indent << "          poly: " << poly);
//	if (balloon)
//		balloon->DeepEcho(indent2);
//	else
		if(flag) _pprintLine_(indent << "       balloon: " << balloon);
//	if (list)
//		list->DeepEcho(indent2);
//	else
		if(flag) _pprintLine_(indent << "          list: " << list);

	return;
}
/*}}}*/
/*FUNCTION KML_Style::Write {{{*/
void  KML_Style::Write(FILE* filout,const char* indent){

	char  indent2[81];

	fprintf(filout,"%s<Style",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	KML_StyleSelector::Write(filout,indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

//	if (icon)
//		icon->Write(filout,indent2);
//	if (label)
//		label->Write(filout,indent2);
	if (line)
		line->Write(filout,indent2);
	if (poly)
		poly->Write(filout,indent2);
//	if (balloon)
//		balloon->Write(filout,indent2);
//	if (list)
//		list->Write(filout,indent2);

	fprintf(filout,"%s</Style>\n",indent);

	return;
}
/*}}}*/
/*FUNCTION KML_Style::Read {{{*/
void  KML_Style::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
		if      (!strncmp(kstri,"</Style", 7)) {
			xDelete<char>(kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
		  {_error_("KML_Style::Read -- Unexpected closing tag " << kstri << ".\n");}
		else if (strncmp(kstri,"<",1))
		  {_error_("KML_Style::Read -- Unexpected field \"" << kstri << "\".\n");}

//		else if (!strncmp(kstri,"<IconStyle",10)) {
//			icon      =new KML_IconStyle();
//			icon      ->Read(fid,kstri);
//		}

//		else if (!strncmp(kstri,"<LabelStyle",11)) {
//			label     =new KML_LabelStyle();
//			label     ->Read(fid,kstri);
//		}

		else if (!strncmp(kstri,"<LineStyle",10)) {
			line      =new KML_LineStyle();
			line      ->Read(fid,kstri);
		}

		else if (!strncmp(kstri,"<PolyStyle",10)) {
			poly      =new KML_PolyStyle();
			poly      ->Read(fid,kstri);
		}

//		else if (!strncmp(kstri,"<BalloonStyle",13)) {
//			balloon   =new KML_BalloonStyle();
//			balloon   ->Read(fid,kstri);
//		}

//		else if (!strncmp(kstri,"<ListStyle",10)) {
//			list      =new KML_ListStyle();
//			list      ->Read(fid,kstri);
//		}

		else if (!strncmp(kstri,"<",1))
			KML_StyleSelector::Read(fid,kstri);

		xDelete<char>(kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xDelete<char>(pcom[ncom-1]);
	xDelete<char*>(pcom);

	return;
}
/*}}}*/
