/* \file DetermineGlobalSize.cpp
 * \brief: routine to determine global size from local size 
 */

#include <stdio.h>
#include <math.h>
#include "../../../shared/shared.h"
#include "../../../shared/Numerics/types.h"

int DetermineGlobalSize(int local_size,COMM comm){

	/*output: */
	int  global_size;

	MPI_Reduce(&local_size, &global_size, 1, MPI_INT, MPI_SUM, 0, comm);
	MPI_Bcast(&global_size,1,MPI_INT,0,comm);

	return global_size;

}
