/*\file PrintfFunction.c
 *\brief: this function is used by the _printf_ macro, to take into account the 
 *fact we may be running on a cluster. 
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdarg.h>
#ifdef _HAVE_ANDROID_NDK_
#include <android/log.h>
#endif
#include "./Print.h"
#include "../Comm/Comm.h"
#include "../../shared/MemOps/MemOps.h"

int PrintfFunction(const char* format,...){
	/*http://linux.die.net/man/3/vsnprintf*/

	/*string to be printed: */
	char *buffer = NULL;
	int   n,size = 100;
	int   my_rank;
	//variable list of arguments
	va_list args;

	/*recover my_rank:*/
	my_rank=IssmComm::GetRank();

	while(true){

		/*allocate buffer for given string size*/
		buffer=xNew<char>(size);

		/* Try to print in the allocated space. */
		va_start(args, format);
		n=vsnprintf(buffer,size,format,args);
		va_end(args);

		/* If that worked, return the string. */
		if(n>-1 && n<size) break;

		/* Else try again with more space. */
		if(n>-1)   /* glibc 2.1 */
		 size=n+1; /* precisely what is needed */
		else       /* glibc 2.0 */
		 size*=2;  /* twice the old size */

		xDelete<char>(buffer);
	}

	/*Ok, if we are running in parallel, get node 0 to print*/
	if(my_rank==0)_printString_(buffer);

	/*Clean up and return*/
	xDelete<char>(buffer);
	return 1;
}
int PrintfFunction(const string & message){
	int  my_rank;

	/*recover my_rank:*/
	my_rank=IssmComm::GetRank();

	if(my_rank==0){
		#ifdef _HAVE_ANDROID_JNI_
		__android_log_print(ANDROID_LOG_INFO, "Native",message.c_str());
		#else
		printf("%s\n",message.c_str());
		#endif
	}
	return 1;
}
int PrintfFunction2(const string & message){
	int  my_rank;

	/*recover my_rank:*/
	my_rank=IssmComm::GetRank();

	if(my_rank==0){
		printf("%s",message.c_str());
	}
	return 1;
}
