/* \file macros.h
 * \brief: global macros used in the whole code
 */

/*Header {{{*/
#ifndef _MACROS_H_
#define _MACROS_H_

#include <iostream>
#include <sstream>
#include <iomanip>
#include "./typedefs.h"

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
/*}}}*/


/*Exceptions: */
/* _assert_ {{{*/
/*Assertion macro: do nothing if macro _ISSM_DEBUG_ undefined*/
#ifdef _ISSM_DEBUG_ 
#define _assert_(statement)\
  if (!(statement)) _error_("Assertion \""<<#statement<<"\" failed, please report bug to "<<PACKAGE_BUGREPORT)
#else
#define _assert_(ignore)\
  ((void) 0)
#endif
/*}}}*/
/* _error_ {{{*/
/*new Error exception macro*/
#ifdef _INTEL_WIN_
#define _error_(StreamArgs)\
   do{std::ostringstream aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy; \
   aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy << StreamArgs << std::ends; \
   throw ErrorException(aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy.str());}while(0)
#else
#define _error_(StreamArgs)\
	do{std::ostringstream aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy; \
   aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy << StreamArgs << std::ends; \
   throw ErrorException(__FILE__,__func__,__LINE__,aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy.str());}while(0)
#endif
/*}}}*/
/* ExceptionTrapBegin/ExceptionTrapEnd {{{*/

/*The following macros hide the error exception handling in a matlab module. Just put 
 * ExceptionTrapBegin(); and ExceptionTrapEnd(); at the beginning and end of a module, and c++ exceptions 
 * will be trapped. Really nifty!*/

#define ExceptionTrapBegin(); \
	try{

#define ExceptionTrapEnd(); }\
	catch(ErrorException &exception){\
		exception.Report();\
		return 0;\
	}\
	catch (exception& e) {\
		_printf_(true,"Standard exception: %s\n",e.what());\
		return 0;\
	}\
	catch(...){\
		_printf_(true,"An unexpected error occurred");\
		return 0;\
	}
/*}}}*/

#endif
