/*!\file:  IssmToolkitUtils.cpp
 * \brief utilities used throughout our ISSM toolkit
 */ 

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../shared/MemOps/MemOps.h"
#include "../../io/Comm/Comm.h"
#include "../../include/macros.h"
#include "../../classes/ToolkitOptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/Exceptions/exceptions.h"
#include "./IssmToolkitUtils.h"
#include <string.h>
/*}}}*/

/*Routines: */
int IssmMatTypeFromToolkitOptions(void){ /*{{{*/

	char *mat_type      = NULL;
	int   mat_type_enum;
	int   num_procs     = 0;
	bool  isparallel    = false;

	/*first, figure out if we are running in parallel: */
	num_procs=IssmComm::GetSize();
	if(num_procs>1)isparallel=true;

	/*retrieve matrix type as a string, from the Toolkits Options database, similar to what Petsc does. Actually, 
	 *we try and stick with the Petsc matrix types: */
	mat_type=ToolkitOptions::GetToolkitOptionValue("mat_type");

	if ((strcmp(mat_type,"mpidense")==0) || (strcmp(mat_type,"dense")==0)){
		if (isparallel) mat_type_enum=MpiDenseEnum;
		else mat_type_enum=DenseEnum;
	}
	else _error_("matrix type not supported yet!");

	/*free ressources: */
	xDelete<char>(mat_type);

	/*return: */
	return mat_type_enum;
} /*}}}*/
int IssmVecTypeFromToolkitOptions(void){ /*{{{*/

	char* vec_type=NULL;
	int   vec_type_enum;
	int   num_procs=0;
	bool  isparallel=false;

	/*first, figure out if we are running in parallel: */
	num_procs=IssmComm::GetSize();
	if(num_procs>1)isparallel=true;

	/*retrieve vector type as a string, from the Toolkits Options database, similar to what Petsc does. Actually, 
	 *we try and stick with the Petsc vector types: */
	vec_type=ToolkitOptions::GetToolkitOptionValue("vec_type");

	if ((strcmp(vec_type,"mpi")==0) || (strcmp(vec_type,"seq")==0)){
		if (isparallel) vec_type_enum=MpiEnum;
		else vec_type_enum=SeqEnum;
	}
	else _error_("vector type not supported yet!");

	/*free ressources: */
	xDelete<char>(vec_type);

	/*return: */
	return vec_type_enum;
} /*}}}*/  
