/* \file IssmComm.h
 * \brief  create a class with a static comm, and static methods to access it
 * This is a way of protecting access to the communicator.
 */

#ifndef _ISSM_COMM_H
#define _ISSM_COMM_H

/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./CommDef.h"

/*}}}*/

class IssmComm {

	private:
		static COMM comm;
		static bool parallel;

	public:
		static void SetComm(COMM incomm);
		static void SetComm(void);
		static COMM GetComm(void);
		static int GetRank(void);
		static int GetSize(void);
};

#endif  /* _ISSM_COMM_H */
