/*
 * CreateConstraintsHydrologyDCInefficient.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../io/io.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"
#include "../../IoModelToConstraintsx/IoModelToConstraintsx.h"

void	CreateConstraintsHydrologyDCInefficient(Constraints** pconstraints, IoModel* iomodel){

	/*Recover pointer: */
	int          hydrology_model;
	Constraints* constraints=*pconstraints;

	/*retrieve some parameters: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints();

	if(hydrology_model!=HydrologydcEnum){
		*pconstraints=constraints;
		return;
	}

	IoModelToConstraintsx(constraints,iomodel,HydrologydcSpcsedimentHeadEnum,HydrologyDCInefficientAnalysisEnum);

	/*Assign output pointer: */
	*pconstraints=constraints;
}
