/*
 * CreateConstraintsHydrologyShreve.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../io/io.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"
#include "../../IoModelToConstraintsx/IoModelToConstraintsx.h"

void	CreateConstraintsHydrologyShreve(Constraints** pconstraints, IoModel* iomodel){

	/*Recover pointer: */
	int          hydrology_model;
	bool         isefficientlayer;
	Constraints* constraints=*pconstraints;

	/*retrieve some parameters: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints();

	if(hydrology_model!=HydrologyshreveEnum){
		*pconstraints=constraints;
		return;
	}

	IoModelToConstraintsx(constraints,iomodel,HydrologyshreveSpcwatercolumnEnum,HydrologyShreveAnalysisEnum);

	/*Assign output pointer: */
	*pconstraints=constraints;
}
