/*!\file:  exprintf
 * \brief this is a modification of the sprintf function. 
 * Instead of returning an int, it will return the char* itself.
 * The advantage is to be able to do things like: 
 * ErrorException(exprintf("%s%i\n","test failed for id:",id));
 */ 

#include <stdarg.h>
#include <stdio.h>
#include "../Alloc/alloc.h"

char* exprintf(const char* format,...){

	/*returned string: */
	char *buffer = NULL;
	int   n,size = 100;

	//variable list of arguments
	va_list args;

	while(true){

		/*allocate buffer for given string size*/
		buffer=xNew<char>(size);

		/* Try to print in the allocated space. */
		va_start(args, format);
#ifndef WIN32
		n=vsnprintf(buffer,size,format,args);
#else
		n=vsnprintf(buffer,size,format,args);
#endif
		va_end(args);

		/* If that worked, return the string. */
		if(n>-1 && n<size) break;

		/* Else try again with more space. */
		if(n>-1)   /* glibc 2.1 */
		 size=n+1; /* precisely what is needed */
		else       /* glibc 2.0 */
		 size*=2;  /* twice the old size */

		xDelete<char>(buffer);
	}

	return buffer;
}
