	if options['solution_type'] == FlaimSolutionEnum():
		md=flaim_sol(md,options)
		[md.private.solution]=EnumToString(options['solution_type'])
		return md

	#Do we load results only?
	if options['loadonly']:  
		md=loadresultsfromcluster(md)
		return md

	#Write all input files
	marshall(md)                                           # bin file
	md.toolkits.ToolkitsFile(md.miscellaneous.name+'.toolkits')    # toolkits file
	cluster.BuildQueueScript(md.private.runtimename,md.miscellaneous.name,md.private.solution,md.settings.io_gather,md.debug.valgrind,md.debug.gprof)    # queue file

	#Stop here if batch mode
	if strcmpi(options['batch'],'yes'):
		print 'batch mode requested: not launching job interactively'
		print 'launch solution sequence on remote cluster by hand'
		return md

	#Launch job
	modelname = md.miscellaneous.name
	filelist  = [modelname+'.bin ',modelname+'.toolkits ',modelname+'.queue ']
	if md.qmu.isdakota:
		filelist.append(modelname+'.qmu.in')
	cluster.LaunchQueueJob(md.miscellaneous.name,md.private.runtimename,filelist)

	#did we even try to run? if so, wait on lock
	if strcmpi(options['upload'],'on'):
		print 'solve done uploading test decks'
		return md

	#wait on lock
	if md.settings.waitonlock>0:
		#we wait for the done file
		islock=waitonlock(md)
		if islock==0:    #no results to be loaded
			print 'The results must be loaded manually with md=loadresultsfromcluster(md).'
		else:            #load results
			print 'loading results from cluster'
			md=loadresultsfromcluster(md)

	#post processes qmu results if necessary
	if md.qmu.isdakota:
		if not strncmpi(options['keep'],'y',1):
			shutil.rmtree('qmu'+str(os.getpid()))

	return md

