function plot_transient_movie(md,options_structure,width,i);
%PLOT_TRANSIENT_MOVIE - plot a transient result as a movie
%   Usage:
%      plot_transient_movie(md,options_structure,width,i);
%
%   See also: PLOTMODEL, PLOT_UNIT, PLOT_MANAGER

	%prepare subplot
	subplot(width,width,i); 

	%xlim
	if ~isnan(options_structure.transient_movie_field),
		field=options_structure.transient_movie_field;
	else
		error('specify transient_movie_field in options list');
	end

	%process model
	[x y z elements is2d]=processmesh(md,options_structure);

	%loop over the time steps
	for i=1:length(md.results.transient)
		eval(['data=md.results.transient(' num2str(i) ').' num2str(field) ';']);

		%process data
		[data isongrid]=processdata(md,data,options_structure);
		titlestring=[field ' at time ' num2str(md.results.transient(i).time/md.yts) ' year'];
		plot_unit(x,y,z,elements,data,isongrid,is2d,options_structure)
		apply_options_movie(md,options_structure,titlestring);
		
		if ~isnan(options_structure.transient_movie_output),
			frames(i)=getframe(gcf);
		else
			pause(0.5)
		end
	end

	%output movie if requested.
	if ~isnan(options_structure.transient_movie_output),
		filename=options_structure.transient_movie_output;
		
		%fps 
		if ~isnan(options_structure.transient_movie_fps),
			fps=options_structure.transient_movie_fps;
		else
			fps=5;
		end
		%quality
		if ~isnan(options_structure.transient_movie_quality),
			quality=options_structure.transient_movie_quality;
		else
			quality=75;
		end
		movie2avi(frames,filename,'fps',fps,'quality',quality);
	end

end %function

function apply_options_movie(md,options_structure,titlestring)
	%apply options
	if isnan(options_structure.title)
		options_structure.title=titlestring;
	end 
	if isnan(options_structure.colorbar)
		options_structure.colorbar=1;
	end
	applyoptions(md,[],options_structure);
end
