function ExportGmsh(md,filename)
%EXPORTGMSH - export mesh to gmsh format
%
%   Usage:
%      ExportGmsh(md,filename)


t1=clock;fprintf('%s',['writing gmsh mesh file']);
fid=fopen(filename,'w');

%initialiation
fprintf(fid,'\n%s\n%i\n','MeshVersionFormatted',1);

%dimension
fprintf(fid,'\n%s\n%i\n','Dimension',2);

%Vertices
fprintf(fid,'\n%s\n%i\n\n','Vertices',md.mesh.numberofvertices);
fprintf(fid,'%8g %8g %i\n',[md.mesh.x md.mesh.y zeros(md.mesh.numberofvertices,1)]');

%Triangles
fprintf(fid,'\n\n%s\n%i\n\n','Triangles',md.mesh.numberofelements);
fprintf(fid,'%i %i %i %i\n',[md.mesh.elements zeros(md.mesh.numberofelements,1)]');

%close
fclose(fid);
t2=clock;fprintf('%s\n',[' done (' num2str(etime(t2,t1)) ' seconds)']);
