%GIA test, inspired on test101
md=triangle(model(),'../Exp/Square.exp',100000.);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');

%% define loading history 
md.timestepping.start_time=2400000; %2,400 kyr
md.timestepping.final_time=2500000; %2,400 kyr
md.geometry.thickness=[...
	zeros(md.mesh.numberofvertices+1,1),...
	[md.geometry.thickness; 1.0e-4],...
	[md.geometry.thickness; md.timestepping.start_time],...
	];

%% solve for GIA deflection 
md.cluster=generic('name',oshostname(),'np',3);
md.verbose=verbose('1111111');
md=solve(md,GiaSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'GiaW','GiadWdt'};
field_tolerances={1e-13,1e-13};
field_values={...
	(md.results.GiaSolution.GiaW),...
	(md.results.GiaSolution.GiadWdt),...
	};
