from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class gia(object):
	"""
	GIA class definition

	   Usage:
	      gia=gia();
	"""

	def __init__(self): # {{{
		self.lithosphere_thickness         = float('NaN');
		self.output_rates                  = 0;
		self.cross_section_shape           = 0;
	
		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		
		string='   gia solution parameters:' 
		
		string="%s\n%s"%(string,fielddisplay(self,'lithosphere_thickness','lithosphere thickness constraints (NaN means no constraint) [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'output_rates','1: deflection (w) [m], 2: rate of deflection (dw/dt) [mm/yr]'))
		string="%s\n%s"%(string,fielddisplay(self,'cross_section_shape',"1: square-edged, 2: elliptical-edged surface"))
		return string
		#}}}
	def setdefaultparameters(self): # {{{

		self.output_rates=1;  
		self.cross_section_shape=1; 

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		# Early return 
		if (GiaAnalysisEnum() not in  analyses):
			return md 
		
		md = checkfield(md,'gia.lithosphere_thickness','NaN',1,'size',[md.mesh.numberofvertices,1],'>',0)
		md = checkfield(md,'gia.output_rates','numel',[1],'values',[1,2])
		md = checkfield(md,'gia.cross_section_shape','numel',[1],'values',[1,2])

		#be sure that if we are running a prognostic ice flow model coupled with gia, that thickness forcings 
		#are not provided into the future.

		return md
	# }}}
	def marshall(self,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','lithosphere_thickness','format','DoubleMat','mattype',1);
		WriteData(fid,'object',self,'fieldname','output_rates','format','Integer');
		WriteData(fid,'object',self,'fieldname','cross_section_shape','format','Integer');
	# }}}
