/*!\file:  ToolkitsOptionsFromAnalysis.cpp
 * \brief: for each analysis, setup the issmoptions string. 
 * This is mainly for the case where we run our toolkits using petsc. In this case, we need to 
 * plug our toolkits options directly into the petsc options database. This is the case for each analysis type 
 * and parameters
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../classes/classes.h"
#include "../../Container/Parameters.h"
#include "../../toolkits/toolkits.h"

void ToolkitsOptionsFromAnalysis(Parameters* parameters,int analysis_type){

	char* options=NULL;

	/*Recover first the options string for this analysis: */
	options=OptionsFromAnalysis(parameters,analysis_type);

	/*Initialize our Toolkit Options: */
	ToolkitOptions::Init(options);

	#ifdef _HAVE_PETSC_
		/*In case we are using PETSC, we do not rely on issmoptions. Instead, we dump issmoptions into the Petsc 
		 * options database: */

		#if _PETSC_MAJOR_ == 2 
		PetscOptionsDestroy();
		PetscOptionsCreate();
		//PetscOptionsCheckInitial_Private();
		//PetscOptionsCheckInitial_Components();
		PetscOptionsSetFromOptions();
		PetscOptionsInsertMultipleString(options); //our patch
		#else
		PetscOptionsSetFromOptions();
		PetscOptionsClear();
		//PetscOptionsSetFromOptions();
		PetscOptionsInsertMultipleString(options); //our patch
		#endif

	#endif

	xDelete<char>(options);
}
