%GIA class definition
%
%   Usage:
%      gia=gia();

classdef gia
	properties (SetAccess=public) 
		lithosphere_thickness         = NaN;
		output_rates                  = 0;
		cross_section_shape           = 0;
	end
	methods
		function obj = gia(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
		obj.output_rates=1;  %don't output  rates by default (see irate in GiaDeflectionCorex)
		obj.cross_section_shape=1; %square as default (see iedge in GiaDeflectionCorex)
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
		 
			if ~ismember(GiaAnalysisEnum(),analyses), return; end
			md = checkfield(md,'gia.lithosphere_thickness','NaN',1,'size',[md.mesh.numberofvertices 1],'>',0);
			md = checkfield(md,'gia.output_rates','numel',[1],'values',[1,2]);
			md = checkfield(md,'gia.cross_section_shape','numel',[1],'values',[1,2]);

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   gia parameters:'));

			fielddisplay(obj,'lithosphere_thickness','lithosphere thickness[km]');
			fielddisplay(obj,'output_rates','1: fetch w solution (m) (default). 2: fetch dw/dt (mm/yr). See irate in GiaDeflectionCore');
			fielddisplay(obj,'cross_section_shape','1: square-edged (default). 2: elliptical.  See iedge in GiaDeflectionCore');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'data',obj.lithosphere_thickness,'format','DoubleMat','mattype',1,'enum',GiaLithosphereThicknessEnum());
			WriteData(fid,'object',obj,'fieldname','output_rates','format','Integer');
			WriteData(fid,'object',obj,'fieldname','cross_section_shape','format','Integer');
		end % }}}
	end
end
