/*!\file:  IssmSolver.h
 * \brief main hook up from Solver toolkit object (in src/c/classes/toolkits) to the ISSM toolkit
 */ 

#ifndef _ISSM_SOLVER_H_
#define _ISSM_SOLVER_H_

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../include/types.h"

/*}}}*/

template <class doubletype> class IssmVec;
template <class doubletype> class IssmMat;
class Parameters;

void IssmSolve(IssmVec<IssmDouble>** puf,IssmMat<IssmDouble>* Kff, IssmVec<IssmDouble>* pf,Parameters* parameters);
void SolverxSeq(IssmPDouble **pX, IssmPDouble *A, IssmPDouble *B,int n);
void SolverxSeq(IssmPDouble *X, IssmPDouble *A, IssmPDouble *B,int n);

#if defined(_HAVE_ADOLC_) && !defined(_WRAPPERS_)
void SolverxSeq(IssmDouble *X,IssmDouble *A,IssmDouble *B,int n, Parameters* parameters);
// call back functions:
ADOLC_ext_fct EDF_for_solverx;
ADOLC_ext_fct_fos_forward EDF_fos_forward_for_solverx;
ADOLC_ext_fct_fos_reverse EDF_fos_reverse_for_solverx;
ADOLC_ext_fct_fov_forward EDF_fov_forward_for_solverx;
ADOLC_ext_fct_fov_reverse EDF_fov_reverse_for_solverx;
#endif

#endif 
