/*!\file GetSolutionFromInputsx
 * \brief: update datasets using  parameter inputs
 */

#include "./GetSolutionFromInputsx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void	GetSolutionFromInputsx( Vector<IssmDouble>** psolution, Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads, Materials* materials,  Parameters* parameters){

	/*intermediary: */
	int gsize;
	int i;
	Element* element=NULL;

	int configuration_type;

	/*output: */
	Vector<IssmDouble>* solution=NULL;
	
	if(VerboseModule()) _pprintLine_("   Get solution from inputs");

	/*retrive parameters: */
	parameters->FindParam(&configuration_type,ConfigurationTypeEnum);

	/*Get size of vector: */
	gsize=nodes->NumberOfDofs(configuration_type,GsetEnum);
	if (gsize==0) _error_("Allocating a Vec of size 0 as gsize=0 for configuration: " << EnumToStringx(configuration_type));

	/*Initialize solution: */
	solution=new Vector<IssmDouble>(gsize);

	/*Go through elements and plug solution: */
	for (i=0;i<elements->Size();i++){
		element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->GetSolutionFromInputs(solution);
	}

	/*Assemble vector: */
	solution->Assemble();

	/*Assign output pointers:*/
	*psolution=solution;

}
