/*!\file GaussTria.h
 * \brief: header file for node object
 */

#ifndef _GAUSSTRIA_H_
#define _GAUSSTRIA_H_

/*Headers:*/
/*{{{*/
#include "./../../shared/shared.h"
/*}}}*/

class GaussTria{

	private:
		int numgauss;
		IssmPDouble* weights;
		IssmPDouble* coords1;
		IssmPDouble* coords2;
		IssmPDouble* coords3;

	public:
		IssmPDouble weight;
		IssmDouble coord1;
		IssmDouble coord2;
		IssmDouble coord3;

	public:

		/*GaussTria constructors, destructors*/
		GaussTria();
		GaussTria(int order);
		GaussTria(int index1,int index2,int order);
		GaussTria(int index,IssmPDouble r1, IssmPDouble r2,bool maintlyfloating,int order);
		~GaussTria();

		/*Methods*/
		int  begin(void);
		int  end(void);
		void Echo(void);
		void GaussFromCoords(IssmDouble x1,IssmDouble y1,IssmDouble* xyz_list);
		void GaussPoint(int ig);
		void GaussVertex(int iv);
		void GaussCenter(void);
		void GaussEdgeCenter(int index1,int index2);
};
#endif  /* _GAUSSTRIA_H_ */
