/*!\file Exp2Kml.h
 * \brief: prototype for exp to kml file conversion mex module.
 */

#ifndef _EXP2KML_H
#define _EXP2KML_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

#include "../bindings.h"
#include "../../c/include/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__  "Exp2Kml"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define EXP_IN prhs[0]
#define KML_IN prhs[1]
#define SGN_IN prhs[2]
/* serial output macros: */
#define RET_OUT    (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define EXP_IN PyTuple_GetItem(args,0)
#define KML_IN PyTuple_GetItem(args,1)
#define SGN_IN PyTuple_GetItem(args,2)
/* serial output macros: */
#define RET_OUT    output,0
#endif

/* serial arg counts: */
#undef NRHS
#define NRHS  3
#undef NLHS
#define NLHS  1

#endif
