/*!\file:  DistributeNumDofs.cpp
 * \brief: figure out the maximum number of dofs per node.
 */ 

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void DistributeNumDofs(DofIndexing* index,int analysis_type,IssmDouble* vertices_type){

	/*For now, we distribute by analysis_type, later, we will distribute using the analysis_type,
	 * but also the vertices_type: */

	int numdofs=2; //default numdofs
	int* doftype=NULL;

	/*ok, according to analysis type: */
	if (analysis_type==DiagnosticHorizAnalysisEnum){
		if (vertices_type[0]==MacAyealApproximationEnum){
			numdofs=2;
		}
		else if (vertices_type[0]==L1L2ApproximationEnum){
			numdofs=2;
		}
		else if (vertices_type[0]==PattynApproximationEnum){
			numdofs=2;
		}
		else if (vertices_type[0]==HutterApproximationEnum){
			numdofs=2;
		}
		else if (vertices_type[0]==StokesApproximationEnum){
			numdofs=4;
		}
		else if (vertices_type[0]==NoneApproximationEnum){
			numdofs=4;
		}
		else if (vertices_type[0]==MacAyealPattynApproximationEnum){
			numdofs=4;
			doftype=xNew<int>(numdofs);
			doftype[0]=MacAyealApproximationEnum;
			doftype[1]=MacAyealApproximationEnum;
			doftype[2]=PattynApproximationEnum;
			doftype[3]=PattynApproximationEnum;
		}
		else if (vertices_type[0]==PattynStokesApproximationEnum){
			numdofs=6;
			doftype=xNew<int>(numdofs);
			doftype[0]=PattynApproximationEnum;
			doftype[1]=PattynApproximationEnum;
			doftype[2]=StokesApproximationEnum;
			doftype[3]=StokesApproximationEnum;
			doftype[4]=StokesApproximationEnum;
			doftype[5]=StokesApproximationEnum;
		}
		else if (vertices_type[0]==MacAyealStokesApproximationEnum){
			numdofs=6;
			doftype=xNew<int>(numdofs);
			doftype[0]=MacAyealApproximationEnum;
			doftype[1]=MacAyealApproximationEnum;
			doftype[2]=StokesApproximationEnum;
			doftype[3]=StokesApproximationEnum;
			doftype[4]=StokesApproximationEnum;
			doftype[5]=StokesApproximationEnum;
		}
		else _error_("Approximationtype " << reCast<int>(*vertices_type) << " (" << EnumToStringx(reCast<int>(*vertices_type)) << ") not implemented yet for DiagnosticHoriz");
	}
	else if (analysis_type==DiagnosticVertAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==DiagnosticHutterAnalysisEnum){
		numdofs=2;
	}
	else if (analysis_type==BedSlopeAnalysisEnum || analysis_type==SurfaceSlopeAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==ThermalAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==EnthalpyAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==HydrologyDCInefficientAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==HydrologyDCEfficientAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==HydrologyShreveAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==MeltingAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==PrognosticAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==GiaAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==BalancethicknessAnalysisEnum){
		numdofs=1;
	}
	else _error_("analysis type: " << analysis_type << " (" << EnumToStringx(analysis_type) << ") not implemented yet");

	/*Now initialize the index*/
	index->Init(numdofs,doftype);

	/*Clean up*/
	 xDelete<int>(doftype);
}
