/*!\file: CreateParametersHydrologyShreve.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void CreateParametersHydrologyShreve(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){

	Parameters *parameters = NULL;
	int         hydrology_model;
	bool        isefficientlayer;

	/*Get parameters: */
	parameters=*pparameters;

	/*retrieve some parameters: */
	iomodel->Constant(&hydrology_model,HydrologyEnum);

	/*Now, do we really want Shreve?*/
	if(hydrology_model!=HydrologyshreveEnum){
		*pparameters=parameters;
		return;
	}

	parameters->AddObject(new IntParam(HydrologyEnum,hydrology_model));
	parameters->AddObject(iomodel->CopyConstantObject(HydrologyshreveStabilizationEnum));

	/*Assign output pointer: */
	*pparameters=parameters;
}
