      subroutine qwise(t,ta,qjadon,xi0,xi1,xi2,slope,ycept,decay,bhaq)
      implicit double precision (a-h,o-z)
      double precision decay(2)
      common /blockn/ irate
      iprate = irate + 1
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c This subroutine retrieves the convolution for the J-th linear piece-wise
c q hat function (the load shape or Bessel function part having been removed)
c with the free-decay solution. (see notes of 3-27-97 "convo.ice" Mathematica
c session).  The convolution is returned as "bhaq".
c
c  THIS ROUTINE REPLACES pwise.f ONLY FOR t <  time(Ntime) *
c  (such that the load is still in place at time t).       *
c
c Note irate = 1 case has to be applied to the linear term only (freed.f applies
c this correction to exponential terms)
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      xg1 = xi1/(decay(1)*decay(1))
      xg2 = xi2/(decay(2)*decay(2))
      gb1 = decay(1)*ycept
      gb2 = decay(2)*ycept
      go to ( 66, 67 ), iprate
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c define xi0t term:
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   66 xi0t = (xi0 + qjadon) * ( ( slope * t ) + ycept )
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c define xi1t term:
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      xi1t = xg1 * (
     1              gb1 + slope * ( ( t * decay(1) ) - 1.0d0 )
     2          - ( gb1 + slope * ( ( ta * decay(1) ) - 1.0d0 ))
     3                                   * dexp( decay(1) * (ta - t) )
     4                       )
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c define xi2t term:
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      xi2t = xg2 * (
     1              gb2 + slope * ( ( t * decay(2) ) - 1.0d0 )
     2          - ( gb2 + slope * ( ( ta * decay(2) ) - 1.0d0 ) )
     3                                   * dexp( decay(2) * (ta - t) )
     4                       )
      go to 90
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c And the rate equivalents:
c (sign switch due to freed.f already
c having corrected in x1t, x2t pass).
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   67 xi0t = (xi0 + qjadon) * slope 
      xi1t =-xg1 * (
     1              slope  
     2     + ( gb1 + slope * ( ( ta * decay(1) ) - 1.0d0 ))
     3                                   * dexp( decay(1) * (ta - t) )
     4                       )
      xi2t =-xg2 * (
     1              slope 
     2     + ( gb2 + slope * ( ( ta * decay(2) ) - 1.0d0 ))
     3                                   * dexp( decay(2) * (ta - t) )
     4                       )
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c add terms for the J-th (and final) interval contribution.
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   90 bhaq = xi0t + xi1t + xi2t
      return
      end
