/*!\file: CreateParametersHydrology.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void CreateParametersHydrology(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){

	Parameters *parameters = NULL;
	int         hydrology_model;
	bool        isefficientlayer;

	/*Get parameters: */
	parameters=*pparameters;

	/*retrieve some parameters: */
	iomodel->Constant(&hydrology_model,HydrologyEnum);

	parameters->AddObject(new IntParam(HydrologyEnum,hydrology_model));
	if(hydrology_model==HydrologyshreveEnum){
		parameters->AddObject(iomodel->CopyConstantObject(HydrologyshreveStabilizationEnum));
	}
	else if(hydrology_model==HydrologydcEnum){
		iomodel->FetchData(&isefficientlayer,HydrologydcIsefficientlayerEnum);
			parameters->AddObject(new BoolParam(HydrologydcIsefficientlayerEnum,isefficientlayer));
	}
	else{
		_error_("Hydrology model "<<EnumToStringx(hydrology_model)<<" not supported yet");
	}

	/*Assign output pointer: */
	*pparameters=parameters;
}
