/*!\file GiaDeflectionCorex
 * \brief: GIA solution from Erik Ivins. 
 * Compute deflection wi from a single disk of radius re, load history hes for 
 * numtimes time steps. 
 */

#include "./GiaDeflectionCorex.h"

#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../InputUpdateFromConstantx/InputUpdateFromConstantx.h"

#define Nrsl 1
#define N3G 1
#define Nafter 1
#define Ntime 2
#define Ntimp 3

/*External blocks: {{{*/
struct blockp{
	double pset[7];
};
      
struct blockt{
	double time[Ntimp];
	double bi[Ntime];
	double dmi[Ntime];
};

struct blocko{
	double rhoi;
	double hload[Ntime];
};

struct blocky{
	double zhload[Ntime][N3G];
};
      

extern "C" { 
	int distme_( int* pidisk,int* piedge,int* pisolt);
	extern struct blockp blockp_;
	extern struct blockt blockt_;
	extern struct blocko blocko_;
	extern struct blocky blocky_;
}
/*}}}*/
      
void GiaDeflectionCorex( IssmDouble* pwi, GiaDeflectionCoreArgs* arguments){

	/*output: */
	IssmDouble wi=1;
	
	/*inputs: */
	int iedge=1; //c iedge ......... = 1 square-edged, = 2 elliptical disc x-section  (see naruse.f)
	int idisk=1; // disk #
	int isolt=1002;

	/*intermediary: */

	/*inputs: {{{*/
	IssmDouble ri; //radial distance from center of disk to vertex  i
	IssmDouble re; //radius of disk
	IssmDouble current_he; //thickness at current time
	IssmDouble* hes; //loading history (in ice thickness)
	IssmDouble* times; //loading history times
	int numtimes; //loading history length
	IssmDouble currenttime;

	/*gia material parameters: */
	IssmDouble lithosphere_shear_modulus;
	IssmDouble lithosphere_density;
	IssmDouble mantle_shear_modulus;
	IssmDouble mantle_viscosity;
	IssmDouble mantle_density;
	IssmDouble lithosphere_thickness;

	/*ice properties: */
	IssmDouble rho_ice;

	/*some debug info: */
	int disk_id;
	/*}}}*/

	/*Recover material parameters and loading history: see GiaDeflectionCoreArgs for more details {{{*/
	ri=arguments->ri;
	re=arguments->re;
	current_he=arguments->current_he;
	hes=arguments->hes;
	times=arguments->times;
	numtimes=arguments->numtimes;
	currenttime=arguments->currenttime;
	lithosphere_shear_modulus=arguments->lithosphere_shear_modulus;
	lithosphere_density=arguments->lithosphere_density;
	mantle_shear_modulus=arguments->mantle_shear_modulus;
	mantle_viscosity=arguments->mantle_viscosity;
	mantle_density=arguments->mantle_density;
	lithosphere_thickness=arguments->lithosphere_thickness;
	rho_ice=arguments->rho_ice; 
	disk_id=arguments->idisk;
	/*}}}*/

	/*Documentation for pset coming from naruse.f: 
	c pset(1) ....... h (thickness of elastic lithosphere in km) 
	c pset(2) ....... viscosity of sub-layer in Pa*s 
	c pset(3) ....... elastic rigidity of lithosphere in dynes/cm^2 
	c pset(4) ....... elastic rigidity of sub-lithosphere in dynes/cm^2 
	c pset(5) ....... density of lithosphere in gm/cc 
	c pset(6) ....... density of sub-lithosphere in gm/cc 
	c pset(7) ....... =dset(1)
	c dset(1) ....... disk radius in km 

	Now, let's set pset from the data that we got in input to GiaDeflectionCorex: 
	*/
	blockp_.pset[0]=lithosphere_thickness;
	blockp_.pset[1]=mantle_viscosity;
	blockp_.pset[2]=lithosphere_shear_modulus;
	blockp_.pset[3]=mantle_shear_modulus;
	blockp_.pset[4]=lithosphere_density;
	blockp_.pset[5]=mantle_density;
	blockp_.pset[6]=re;
	blocko_.rhoi=rho_ice;
      
	/*loading history: */
	blocky_.zhload[0][0]=current_he;
	blocky_.zhload[1][0]=current_he;

	/*times: */
	blockt_.time[0]=0.1;
	blockt_.time[1]=2000;
	blockt_.time[2]=1000;


	/*Call distme driver: */
	distme_(&idisk,&iedge,&isolt);

	//printf("disk id: %i bi: [%g,%g] dmi: [%g,%g] \n",disk_id,blockt_.bi[0], blockt_.bi[1],blockt_.dmi[0],blockt_.dmi[1]);

	/*allocate output pointer: */
	*pwi=wi;
}
