/*!\file GiaDeflectionCorex
 * \brief: GIA solution from Erik Ivins. 
 * Compute deflection wi from a single disk of radius re, load history hes for 
 * numtimes time steps. 
 */

#include "./GiaDeflectionCorex.h"

#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../InputUpdateFromConstantx/InputUpdateFromConstantx.h"

void GiaDeflectionCorex( IssmDouble* pwi, GiaDeflectionCoreArgs* arguments){

	/*output: */
	IssmDouble wi=1;

	/*inputs: {{{*/
	IssmDouble ri; //radial distance from center of disk to vertex  i
	IssmDouble re; //radius of disk
	IssmDouble* hes; //loading history (in ice thickness)
	IssmDouble* times; //loading history times
	int numtimes; //loading history length
	IssmDouble currenttime;

	/*gia material parameters: */
	IssmDouble lithosphere_shear_modulus;
	IssmDouble lithosphere_density;
	IssmDouble mantle_shear_modulus;
	IssmDouble mantle_viscosity;
	IssmDouble mantle_density;
	IssmDouble lithosphere_thickness;

	/*ice properties: */
	IssmDouble rho_ice;
	/*}}}*/

	
	/*Recover material parameters and loading history: see GiaDeflectionCoreArgs for more details {{{*/
	ri=arguments->ri;
	re=arguments->re;
	hes=arguments->hes;
	times=arguments->times;
	numtimes=arguments->numtimes;
	currenttime=arguments->currenttime;
	lithosphere_shear_modulus=arguments->lithosphere_shear_modulus;
	lithosphere_density=arguments->lithosphere_density;
	mantle_shear_modulus=arguments->mantle_shear_modulus;
	mantle_viscosity=arguments->mantle_viscosity;
	mantle_density=arguments->mantle_density;
	lithosphere_thickness=arguments->lithosphere_thickness;
	rho_ice=arguments->rho_ice; 
	/*}}}*/

	/*allocate output pointer: */
	*pwi=wi;
}
