%GIA class definition
%
%   Usage:
%      gia=gia();

classdef gia
	properties (SetAccess=public) 
		lithosphere_thickness         = NaN;
	end
	methods
		function obj = gia(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
		 
			if ~ismember(HydrologyAnalysisEnum(),analyses), return; end
			md = checkfield(md,'gia.lithosphere_thickness','NaN',1,'size',[md.mesh.numberofvertices 1],'>',0);

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   gia parameters:'));

			fielddisplay(obj,'lithosphere_thickness','lithosphere thickness[km]');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'data',obj.lithosphere_thickness,'format','DoubleMat','mattype',1,'enum',GiaLithosphereThicknessEnum());
		end % }}}
	end
end
