md=triangle(model(),'../Exp/Square.exp',10000.);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',2);
md.hydrology=(hydrologydc);
md.initialization.sediment_head=0.0*ones(md.mesh.numberofvertices,1);
md.hydrology.spcsediment_head=NaN*ones(md.mesh.numberofvertices,1);
pos=find(md.mesh.y==0);
md.hydrology.spcsediment_head(pos)=0.0;
md.basalforcings.melting_rate = 2.0*ones(md.mesh.numberofvertices,1);
md.timestepping.time_step=0;
md.timestepping.final_time=1.0;
md=solve(md,HydrologySolutionEnum());

%Fields and tolerances to track changes
field_names     ={'SedimentWaterHead'};
field_tolerances={1e-13};
field_values={md.results.HydrologySolution.SedimentHead}