%TOOLKITS class definition
%
%   Usage:
%      obj=toolkits();

classdef toolkits < dynamicprops
    properties (SetAccess=public) 
		 DefaultAnalysis           = struct();
		 %The other properties are dynamic
	 end
	 methods
		 function obj = toolkits(varargin) % {{{
			 switch nargin
				 case 0
					 obj=setdefaultparameters(obj);
				 case 1
					 obj=structtoobj(obj,varargin{1});
				 otherwise
					 error('constructor not supported');
				 end
			 end % }}}
		 function obj = addoptions(obj,analysis,varargin) % {{{
		 % Usage example:
		 %    md.toolkits=addoptions(md.toolkits,DiagnosticHorizAnalysisEnum(),stokesoptions());
		 %    md.toolkits=addoptions(md.toolkits,DiagnosticHorizAnalysisEnum());

			 %Convert analysis from enum to string
			 analysis=EnumToString(analysis);

			 %Create dynamic property if property does not exist yet
			 if ~ismember(analysis,properties(obj)),
				 obj.addprop(analysis);
			 end

			 %Add toolkits options to analysis
			 if nargin==3, obj.(analysis) = varargin{1}; end
		 end
		 %}}}
		 function obj = setdefaultparameters(obj) % {{{

			 %MUMPS is the default toolkits
			 if ismumps(),
				 obj.DefaultAnalysis           = mumpsoptions();
			 else
				 obj.DefaultAnalysis           = iluasmoptions();
			 end

		 end % }}}
		 function disp(obj) % {{{
			 analyses=properties(obj);
			 disp(sprintf('List of toolkits options per analysis:\n'));
			 for i=1:numel(analyses),
				 analysis=analyses{i};
				 disp([analysis ':']);
				 disp(obj.(analysis));
			 end
		 end % }}}
		 function md = checkconsistency(obj,md,solution,analyses) % {{{
			 analyses=properties(obj);
			 for i=1:numel(analyses),
				 if isempty(fieldnames(obj.(analyses{i})))
					 md = checkmessage(md,['md.toolkits.' analyses{i} ' is empty']);
				 end
			 end
		 end % }}}
		 function ToolkitsFile(toolkits,filename) % {{{
		 %TOOLKITSFILE - build toolkits file
		 %
		 %   Build a Petsc compatible options file, from the toolkits model field  + return options string. 
		 %   This file will also be used when the toolkit used is 'issm' instead of 'petsc'
		 %
		 %   Usage:     ToolkitsFile(toolkits,filename);

			 %open file for writing
			 fid=fopen(filename,'w');
			 if fid==-1,
				 error(['ToolkitsFile error: could not open ' filename ' for writing']);
			 end

			 %write header
			 fprintf(fid,'%s%s%s\n','%Toolkits options file: ',filename,' written from Matlab toolkits array');

			 %start writing options
			 analyses=properties(toolkits);
			 for i=1:numel(analyses),
				 analysis=analyses{i};
				 options=toolkits.(analysis);

				 %first write analysis:
				 fprintf(fid,'\n+%s\n',analysis); %append a + to recognize it's an analysis enum

				 %now, write options
				 optionslist=fieldnames(options);
				 for j=1:numel(optionslist),
					 optionname=optionslist{j};
					 optionvalue=options.(optionname);

					 if isempty(optionvalue),
						 %this option has only one argument
						 fprintf(fid,'-%s\n',optionname);
					 else
						 %option with value. value can be string or scalar
						 if isnumeric(optionvalue),
							 fprintf(fid,'-%s %g\n',optionname,optionvalue);
						 elseif ischar(optionvalue),
							 fprintf(fid,'-%s %s\n',optionname,optionvalue);
						 else
							 error(['ToolkitsFile error: option ' optionname ' is not well formatted']);
						 end
					 end
				 end
			 end

			 fclose(fid);
		 end %}}}
	 end
 end
