/*!\file:  OptionsFromAnalysis.cpp
 * \brief: figure out ISSM options for current analysis, return a string.
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <cstring>

#include "../../classes/objects/objects.h"
#include "../../Container/Parameters.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

char* OptionsFromAnalysis(Parameters* parameters,int analysis_type){

	/*output: */
	char*   outstring=NULL;

	/*intermediary: */
	int          dummy;
	IssmDouble  *analyses    = NULL;
	char       **strings     = NULL;
	char        *string      = NULL;
	int          numanalyses;
	int          found       = -1;
	int          i;

	numanalyses=0;
	parameters->FindParam(&strings,&numanalyses,ToolkitsOptionsStringsEnum);

	parameters->FindParam(&analyses,&dummy,ToolkitsOptionsAnalysesEnum);

	if(numanalyses==0)return NULL; //we did not find petsc options, don't bother.

	/*ok, go through analyses and figure out if it corresponds to our analysis_type: */
	for(i=0;i<numanalyses;i++){
		if(analyses[i]==analysis_type){
			found=i;
			break;
		}
	}
	if(found==-1){
		/*still haven't found a list of petsc options, go find the default one, for analysis type NoneAnalysisEnum: */
		for(i=0;i<numanalyses;i++){
			if(analyses[i]==DefaultAnalysisEnum){
				found=i;
				break;
			}
		}
	}
	if (found==-1){
		_error_("could find neither a default analysis nor analysis " << EnumToStringx(analysis_type));
	}

	/*ok, grab the option string: */
	outstring=xNew<char>(strlen(strings[found])+1);
	strcpy(outstring,strings[found]);

	/*Free ressources*/
	xDelete<IssmDouble>(analyses);
	for(i=0;i<numanalyses;i++){
		string=strings[i];
		xDelete<char>(string);
	}
	xDelete<char*>(strings);
	return outstring;
}
