/*
 * IsInPolySerial.c:
 */

#include <math.h>
#include "./exp.h"

int IsInPolySerial(double* in,double* xc,double* yc,int numvertices,double* x,double* y,int nods, int edgevalue){

	double x0,y0;

	/*Go through all vertices of the mesh:*/
	for(int i=0;i<nods;i++){
		if (in[i]){
			/*this vertex already is inside one of the contours, continue*/
			continue;
		}
		/*pick up vertex: */
		x0=x[i];
		y0=y[i];
		if (pnpoly(numvertices,xc,yc,x0,y0,edgevalue)){
			in[i]=1.;
		}
		else{
			in[i]=0.;
		}
	}

	return 1;
}
