/*!\file Bucket.h
 * \brief: header file for Bucket object
 */

#ifndef _BUCKET_H
#define _BUCKET_H

/*Headers:*/
/*{{{*/
#include "./Object.h"
#include "../../shared/Alloc/alloc.h"
/*}}}*/

template <class doubletype> class Bucket: public Object{

	private: 
		int m,n; /*size of local matrix we are storing*/
		/*row and column indices of the matrix we are storing*/
		int* idxm;
		int* idxn; 
		doubletype* values; /*local matrix*/
		InsMode mode; /*mode of insertion for this bucket*/

	public: 
	
		/*constructors, destructors: */
		Bucket(int min,int* idxmin,int nin,int* idxnin,doubletype* valuesin,InsMode modein){ /*{{{*/
			this->m=min;
			this->n=nin;
			this->mode=modein;
			if(this->m){
				this->idxm=xNew<int>(this->m); 
				xMemCpy(this->idxm,idxmin,this->m);
			}
			if(this->n){
				this->idxn=xNew<int>(this->n); 
				xMemCpy(this->idxn,idxnin,this->n);
			}
			if(this->m*this->n){
				this->values=xNew<doubletype>(this->n*this->m);
				xMemCpy(this->values,valuesin,this->n*this->m);
			}
		} /*}}}*/
		~Bucket(){ /*{{{*/
			xDelete<int>(idxm);
			xDelete<int>(idxn);
			xDelete<doubletype>(values);
		} /*}}}*/

		/*object virtual functions definitions:*/
		void    Echo(){ /*{{{*/
			printf("Bucket echo (cpu #: %i): \n",IssmComm::GetRank());
			printf("# rows: %i, #cols: %i\n",this->m,this->n);
		} /*}}}*/
		void    DeepEcho(){ /*{{{*/
			int i,j;

			printf("Bucket echo (cpu #: %i): \n",IssmComm::GetRank());
			printf("# rows: %i, #cols: %i\n",this->m,this->n);
			for (i=0;i<this->m;i++){
				printf("row %i, column indices: ",this->idxm[i]);
				for (j=0;j<this->n;j++){
					printf(" %i",this->idxn[j]);
				}
				printf("\n");
				printf("values: ");
				for (j=0;j<this->n;j++){
					printf(" %i",this->values[m*i+j]);
				}
				printf("\n");
			}
		}
		/*}}}*/
		int     Id(){ /*{{{*/
			return -1;
		} /*}}}*/
		int     ObjectEnum(){ /*{{{*/
			return -1;
		} /*}}}*/
		Object *copy()        {/*{{{*/
			_error_("Not implemented yet (similar to Elements)"); };
		/*}}}*/
};

#endif  /* _BUCKET_H */
