package gov.nasa.jpl.issm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

import android.content.Context;

class GalleryDescription
//////////////////////////////////////////////////////////////////
{
	private ArrayList<String> description;
	private String[] rawtext;
//----------------------------------------------------------------
	public GalleryDescription(Context context)
	{
		description = new ArrayList<String> ();
		InputStreamReader isr = new InputStreamReader(context.getResources().openRawResource(R.raw.text));
		BufferedReader br = new BufferedReader(isr);
		String delimiter = ":";
		String line;
		int index = 0;
		try {
			while ((line = br.readLine()) != null) 
			{
				//this if will continue adding if description is too long to the next line
				if(!line.contains(delimiter))
					description.add(index, description.get(index)+" "+line);
				else
				{	
					rawtext = line.split(delimiter); 
					//slot 0 contains the image number, slot 1 contains the description.
					index = Integer.parseInt(rawtext[0]);
					description.add(index, rawtext[1]);
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
//----------------------------------------------------------------	
	public String getDescription(int index)
	{
		if(index >= description.size())
		{
			return "There is no detailed description for this image yet!";
		}
		return description.get(index);
	}
}
///////////////////////////////////////////////////////////////////