/*!\file MatlabVectorToVector.cpp
 */

/*Headers:*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include <stdio.h>
#include <string.h>
#include "./matlabio.h"
#include "../../c/shared/shared.h"
#include "../../c/toolkits/toolkits.h"

Vector<double>* MatlabVectorToVector(const mxArray* mxvector){

	int dummy;
	Vector<double>* vector=NULL;

	/*allocate vector object: */
	vector=new Vector<double>();

	#ifdef _HAVE_PETSC_
	vector->pvector=MatlabVectorToPetscVec(mxvector);
	#else
	vector->svector=MatlabVectorToIssmSeqVec(mxvector);
	#endif

	return vector;
}
