/*! \file  ContourToMeshx.c
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ContourToMeshx.h"

int ContourToMeshx(IssmSeqVec<double>** pin_nod,IssmSeqVec<double>** pin_elem, double* index, double* x, double* y,DataSet* contours,char* interptype,int nel,int nods, int edgevalue) {

	/*Contour:*/
	double*  in_nod_serial;
	double   value;

	/*threading: */
	ContourToMeshxThreadStruct gate;
	int num=1;
	#ifdef _MULTITHREADING_
	num=_NUMTHREADS_;
	#endif

	/*output: */
	IssmSeqVec<double>* in_nod=NULL;
	IssmSeqVec<double>* in_elem=NULL;
	in_nod  = new IssmSeqVec<double>(nods);
	in_elem = new IssmSeqVec<double>(nel);

	/*initialize thread parameters: */
	gate.contours=contours;
	gate.nods=nods;
	gate.edgevalue=edgevalue;
	gate.in_nod=in_nod;
	gate.x=x;
	gate.y=y;

	/*launch the thread manager with ContourToMeshxt as a core: */
	LaunchThread(ContourToMeshxt,(void*)&gate,num);

	/*Assemble in_nod: */
	in_nod->Assemble();

	/*Get in_nod serialised for next operation: */
	in_nod_serial=in_nod->ToMPISerial();

	/*Take care of the case where an element interpolation has been requested: */
	if ((strcmp(interptype,"element")==0) || (strcmp(interptype,"element and node")==0)){
		for(int n=0;n<nel;n++){
			if ( (in_nod_serial[ (int)*(index+3*n+0) -1] == 1) && (in_nod_serial[ (int)*(index+3*n+1) -1] == 1) && (in_nod_serial[ (int)*(index+3*n+2) -1] == 1) ){
				value=1; in_elem->SetValue(n,value,INS_VAL);
			}
		}
	}

	/*Assemble vectors: */
	in_elem->Assemble();

	/*Assign output pointers: */
	*pin_nod=in_nod;
	*pin_elem=in_elem;

	/*Free ressources:*/
	xDelete<double>(in_nod_serial);

	return 1;
}
