/*
 * UpdateElementsTransient:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../modules/modules.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsTransient(Elements* elements, Parameters* parameters,IoModel* iomodel,int analysis_counter,int analysis_type){

	bool        isgl;
	int         migration_style;
	int         i,numberofvertices;
	IssmDouble  rho_ice,rho_water;
	IssmDouble *phi   = NULL;

	/*Fetch data needed*/
	iomodel->Constant(&isgl,TransientIsgroundinglineEnum);
	iomodel->Constant(&migration_style,GroundinglineMigrationEnum);

	if(isgl==1 && (migration_style==SubelementMigrationEnum || migration_style==SubelementMigration2Enum)){

		/*get parameters and constants: */
		iomodel->Constant(&rho_ice,MaterialsRhoIceEnum);
		iomodel->Constant(&rho_water,MaterialsRhoWaterEnum);
		iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);
		iomodel->FetchData(3,MeshElementsEnum,ThicknessEnum,BathymetryEnum);

		/*Create phi vector */
		phi=xNew<IssmDouble>(numberofvertices);
		for (i=0;i<numberofvertices;i++){
			if(iomodel->my_vertices[i]){
				phi[i] = iomodel->Data(ThicknessEnum)[i] + rho_water/rho_ice * iomodel->Data(BathymetryEnum)[i];
			}
		}

		/*Update elements: */
		for(i=0;i<elements->Size();i++){
			Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
			element->InputCreate(phi,element->Sid(),iomodel,numberofvertices,1,1,GLlevelsetEnum,1);
		}

		/*Free ressources:*/
		iomodel->DeleteData(3,MeshElementsEnum,ThicknessEnum,BathymetryEnum);
		xDelete<IssmDouble>(phi);
	}
}
