/*! \file ControlInput.h 
 *  \brief: header file for triavertexinput object
 */

#ifndef _CONTROLINPUT_H_
#define _CONTROLINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../../../include/include.h"
class GaussTria;
/*}}}*/

class ControlInput: public Input{

	public:
		int    enum_type;
		int    control_id;
		Input* values;
		Input* savedvalues;
		Input* minvalues;
		Input* maxvalues;
		Input* gradient;

		/*ControlInput constructors, destructors: {{{*/
		ControlInput();
		ControlInput(int enum_type,int enum_input,IssmDouble* pvalues,IssmDouble* pmin,IssmDouble* pmax,int id);
		~ControlInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ControlInput management: {{{*/
		int    InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* inputB){_error_("not implemented yet");};
		ElementResult* SpawnResult(int step, IssmDouble time);
		void AddTimeValues(IssmDouble* values,int step,IssmDouble time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void SetInput(Input* in_input);
		void GetInputValue(bool* pvalue);
		void GetInputValue(int* pvalue);
		void GetInputValue(IssmDouble* pvalue);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss,IssmDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss,IssmDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetInputAverage(IssmDouble* pvalue);
		void GetInputAllTimeAverages(IssmDouble** pvalues,IssmDouble** ptimes, int* pnumtimes){_error_("not implemented yet");};
		void GetVxStrainRate2d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(IssmDouble* epsilonvz,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype){_error_("not implemented yet");};
		void SquareMin(IssmDouble* psquaremin, bool process_units,Parameters* parameters){_error_("not implemented yet");};
		void ConstrainMin(IssmDouble minimum){_error_("not implemented yet");};
		void Scale(IssmDouble scale_factor){_error_("not implemented yet");};
		void ArtificialNoise(IssmDouble min,IssmDouble max){_error_("not implemented yet");};
		void AXPY(Input* xinput,IssmDouble scalar){_error_("not implemented yet");};
		void Constrain(void);
		void Constrain(IssmDouble min,IssmDouble max);
		IssmDouble InfinityNorm(void){_error_("not implemented yet");};
		IssmDouble Max(void){_error_("not implemented yet");};
		IssmDouble MaxAbs(void){_error_("not implemented yet");};
		IssmDouble Min(void){_error_("not implemented yet");};
		IssmDouble MinAbs(void){_error_("not implemented yet");};
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_input);
		void GetVectorFromInputs(Vector<IssmDouble>* vector,int* doflist,const char* data);
		void GetVectorFromInputs(Vector<IssmDouble>* vector,int* doflist);
		void GetValuesPtr(IssmDouble** pvalues,int* pnum_values){_error_("not implemented yet");};
		ElementResult* SpawnGradient(int step, IssmDouble time);
		void GetGradient(Vector<IssmDouble>* gradient_vec,int* doflist);
		void ScaleGradient(IssmDouble scale);
		void SetGradient(Input* gradient_in);
		void UpdateValue(IssmDouble scalar);
		void SaveValue(void);
		/*}}}*/

};
#endif  /* _CONTROLINPUT_H */
