/*! \file BoolInput.h 
 *  \brief: header file for triavertexinput object
 */

#ifndef _BOOLINPUT_H_
#define _BOOLINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../../../include/include.h"
class GaussTria;
/*}}}*/

class BoolInput: public Input{

	public:
		/*just hold 3 values for 3 vertices: */
		int  enum_type;
		bool value;

		/*BoolInput constructors, destructors: {{{*/
		BoolInput();
		BoolInput(int enum_type,bool value);
		~BoolInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void    Echo();
		void    DeepEcho();
		int     Id();
		int     ObjectEnum();
		Object *copy();
		/*}}}*/
		/*BoolInput management: {{{*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* inputB){_error_("not implemented yet");};
		ElementResult* SpawnResult(int step, IssmDouble time);
		void Configure(Parameters* parameters);
		void AddTimeValues(IssmDouble* values,int step,IssmDouble time){_error_("not supported yet");};
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue);
		void GetInputValue(int* pvalue);
		void GetInputValue(IssmDouble* pvalue);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss,IssmDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss,IssmDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetInputAverage(IssmDouble* pvalue){_error_("not implemented yet");};
		void GetInputAllTimeAverages(IssmDouble** pvalues,IssmDouble** ptimes, int* pnumtimes){_error_("not implemented yet");};
		void GetVxStrainRate2d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(IssmDouble* epsilonvz,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype);
		void SquareMin(IssmDouble* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(IssmDouble minimum){_error_("not implemented yet");};
		IssmDouble InfinityNorm(void){_error_("InfinityNorm not implemented for booleans");};
		IssmDouble Max(void){_error_("Max not implemented for booleans");};
		IssmDouble MaxAbs(void){_error_("Max not implemented for booleans");};
		IssmDouble Min(void){_error_("Min not implemented for booleans");};
		IssmDouble MinAbs(void){_error_("Min not implemented for booleans");};
		void Scale(IssmDouble scale_factor);
		void ArtificialNoise(IssmDouble min,IssmDouble max){_error_("not implemented yet");};
		void AXPY(Input* xinput,IssmDouble scalar);
		void Constrain(IssmDouble cm_min, IssmDouble cm_max){_error_("Constrain not implemented for booleans");};
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_input){_error_("not supported yet");};
		void GetVectorFromInputs(Vector<IssmDouble>* vector,int* doflist);
		void GetValuesPtr(IssmDouble** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _BOOLINPUT_H */
