/*! \file DoubleInput.h 
 *  \brief: header file for triavertexinput object
 */

#ifndef _DOUBLEINPUT_H_
#define _DOUBLEINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../../../include/include.h"
class GaussTria;
/*}}}*/

class DoubleInput: public Input{

	public:
		int    enum_type;
		IssmDouble value;

		/*DoubleInput constructors, destructors: {{{*/
		DoubleInput();
		DoubleInput(int enum_type,IssmDouble value);
		~DoubleInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*DoubleInput management: {{{*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB);
		Input* PointwiseMin(Input* inputB);
		Input* PointwiseMax(Input* inputB);
		ElementResult* SpawnResult(int step, IssmDouble time);
		void AddTimeValues(IssmDouble* values,int step,IssmDouble time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue);
		void GetInputValue(int* pvalue);
		void GetInputValue(IssmDouble* pvalue);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss,IssmDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss,IssmDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetInputAverage(IssmDouble* pvalue);
		void GetInputAllTimeAverages(IssmDouble** pvalues,IssmDouble** ptimes, int* pnumtimes){_error_("not implemented yet");};
		void GetVxStrainRate2d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussTria* gauss);
		void GetVyStrainRate2d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussTria* gauss);
		void GetVxStrainRate3d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetVyStrainRate3d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetVzStrainRate3d(IssmDouble* epsilonvz,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetVxStrainRate3dPattyn(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetVyStrainRate3dPattyn(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss);
		void ChangeEnum(int newenumtype);
		void SquareMin(IssmDouble* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(IssmDouble minimum);
		void Scale(IssmDouble scale_factor);
		void ArtificialNoise(IssmDouble min,IssmDouble max){_error_("not implemented yet");};
		void AXPY(Input* xinput,IssmDouble scalar);
		void Constrain(IssmDouble cm_min, IssmDouble cm_max);
		IssmDouble InfinityNorm(void){_error_("not implemented yet");};
		IssmDouble Max(void);
		IssmDouble MaxAbs(void);
		IssmDouble Min(void);
		IssmDouble MinAbs(void);
		void Extrude(void){_error_("not supported yet");};
		void VerticallyIntegrate(Input* thickness_input);
		void GetVectorFromInputs(Vector<IssmDouble>* vector,int* doflist);
		void GetValuesPtr(IssmDouble** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _DOUBLEINPUT_H */
