package gov.nasa.jpl.issm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import android.content.Context;

class GalleryDescription
//////////////////////////////////////////////////////////////////
{
	private String[] description;
	private String[] rawtext;
	
//----------------------------------------------------------------
	public GalleryDescription(Context context)
	{
		description = new String[16];
		InputStreamReader isr = new InputStreamReader(context.getResources().openRawResource(R.raw.text));
		BufferedReader br = new BufferedReader(isr);
		String delimiter = ":";
		String line;
		int index = 0;
		try {
			while ((line = br.readLine()) != null) 
			{
				if(!line.contains(delimiter))
					description[index] += line;
				else
				{	
					rawtext = line.split(delimiter); 
					index = Integer.parseInt(rawtext[0]);
					description[index] = rawtext[1];
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
//----------------------------------------------------------------	
	public String getDescription(int index)
	{
		return description[index];
	}
}
///////////////////////////////////////////////////////////////////