from fielddisplay import fielddisplay
from EnumDefinitions import *
from StringToEnum import StringToEnum
from checkfield import *
from WriteData import *

class matdamageice(object):
	"""
	MATDAMAGEICE class definition

	   Usage:
	      matdamageice=matdamageice();
	"""

	def __init__(self,*args):    # {{{
		self.rho_ice                    = 0.
		self.rho_water                  = 0.
		self.rho_freshwater             = 0.
		self.mu_water                   = 0.
		self.heatcapacity               = 0.
		self.latentheat                 = 0.
		self.thermalconductivity        = 0.
		self.meltingpoint               = 0.
		self.beta                       = 0.
		self.mixed_layer_capacity       = 0.
		self.thermal_exchange_velocity  = 0.
		self.rheology_B   = float('NaN')
		self.rheology_n   = float('NaN')
		self.rheology_Z   = float('NaN')
		self.rheology_law = ''

		if not len(args):
			self.setdefaultparameters()
		else:
			raise RuntimeError("constructor not supported")

	# }}}
	def __repr__(self):    # {{{
		s ='   Materials:\n'

		s+="%s\n" % fielddisplay(self,"rho_ice","ice density [kg/m^3]")
		s+="%s\n" % fielddisplay(self,"rho_water","ocean water density [kg/m^3]")
		s+="%s\n" % fielddisplay(self,"rho_freshwater","fresh water density [kg/m^3]")
		s+="%s\n" % fielddisplay(self,"mu_water","water viscosity [N s/m^2]")
		s+="%s\n" % fielddisplay(self,"heatcapacity","heat capacity [J/kg/K]")
		s+="%s\n" % fielddisplay(self,"thermalconductivity","ice thermal conductivity [W/m/K]")
		s+="%s\n" % fielddisplay(self,"meltingpoint","melting point of ice at 1atm in K")
		s+="%s\n" % fielddisplay(self,"latentheat","latent heat of fusion [J/m^3]")
		s+="%s\n" % fielddisplay(self,"beta","rate of change of melting point with pressure [K/Pa]")
		s+="%s\n" % fielddisplay(self,"mixed_layer_capacity","mixed layer capacity [W/kg/K]")
		s+="%s\n" % fielddisplay(self,"thermal_exchange_velocity","thermal exchange velocity [m/s]")
		s+="%s\n" % fielddisplay(self,"rheology_B","flow law parameter [Pa/s^(1/n)]")
		s+="%s\n" % fielddisplay(self,"rheology_n","Glen's flow law exponent")
		s+="%s\n" % fielddisplay(self,"rheology_Z","rheology multiplier")
		s+="%s\n" % fielddisplay(self,"rheology_law","law for the temperature dependance of the rheology: 'None', 'Paterson' or 'Arrhenius'")

		return s
	# }}}
	def setdefaultparameters(self):    # {{{

		#ice density (kg/m^3)
		self.rho_ice=917.

		#ocean water density (kg/m^3)
		self.rho_water=1023.

		#fresh water density (kg/m^3)
		self.rho_freshwater=1000.

		#water viscosity (N.s/m^2)
		self.mu_water=0.001787  

		#ice heat capacity cp (J/kg/K)
		self.heatcapacity=2093.

		#ice latent heat of fusion L (J/kg)
		self.latentheat=3.34*10**5

		#ice thermal conductivity (W/m/K)
		self.thermalconductivity=2.4

		#the melting point of ice at 1 atmosphere of pressure in K
		self.meltingpoint=273.15

		#rate of change of melting point with pressure (K/Pa)
		self.beta=9.8*10**-8

		#mixed layer (ice-water interface) heat capacity (J/kg/K)
		self.mixed_layer_capacity=3974.

		#thermal exchange velocity (ice-water interface) (m/s)
		self.thermal_exchange_velocity=1.00*10**-4

		#Rheology law: what is the temperature dependence of B with T
		#available: none, paterson and arrhenius
		self.rheology_law='Paterson'
	# }}}
	def checkconsistency(self,md,solution,analyses):    # {{{
		md = checkfield(md,'materials.rho_ice','>',0)
		md = checkfield(md,'materials.rho_water','>',0)
		md = checkfield(md,'materials.rho_freshwater','>',0)
		md = checkfield(md,'materials.mu_water','>',0)
		md = checkfield(md,'materials.rheology_B','>',0,'size',[md.mesh.numberofvertices,1])
		md = checkfield(md,'materials.rheology_n','>',0,'size',[md.mesh.numberofelements,1])
		md = checkfield(md,'materials.rheology_Z','>',0,'size',[md.mesh.numberofvertices,1])
		md = checkfield(md,'materials.rheology_law','values',['None','Paterson','Arrhenius'])

		return md
	# }}}
	def marshall(self,fid):    # {{{
		WriteData(fid,'enum',MaterialsEnum(),'data',MatdamageiceEnum(),'format','Integer')
		WriteData(fid,'object',self,'class','materials','fieldname','rho_ice','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','rho_water','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','rho_freshwater','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','mu_water','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','heatcapacity','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','latentheat','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','thermalconductivity','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','meltingpoint','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','beta','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','mixed_layer_capacity','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','thermal_exchange_velocity','format','Double')
		WriteData(fid,'object',self,'class','materials','fieldname','rheology_B','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'class','materials','fieldname','rheology_n','format','DoubleMat','mattype',2)
		WriteData(fid,'object',self,'class','materials','fieldname','rheology_Z','format','DoubleMat','mattype',1)
		WriteData(fid,'data',StringToEnum(self.rheology_law)[0],'enum',MaterialsRheologyLawEnum(),'format','Integer')
	# }}}
